﻿Imports System.Threading
Imports OpcLabs.EasyOpc.DataAccess.Engine
Imports OpcLabs.EasyOpc.DataAccess

Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            'setup some constant values used by this example
            Const TimeoutSeconds As Integer = 3
            Const pc As String = "127.0.0.1"
            Const opc As String = "SWToolbox.TOPServer.V5"
            Const tag As String = "Channel1.Device1.Tag1"

            '
            'create our client object
            Dim EasyOPC As OpcLabs.EasyOpc.DataAccess.EasyDAClient = New OpcLabs.EasyOpc.DataAccess.EasyDAClient
            Dim ClientMode As EasyDAClientMode = New EasyDAClientMode
            Dim UpdateRates As EasyDAClientUpdateRates = New EasyDAClientUpdateRates
            Dim Timeouts As EasyDAClientTimeouts = New EasyDAClientTimeouts
            Dim HoldPeriods As EasyDAClientHoldPeriods = New EasyDAClientHoldPeriods

            '
            'Note: Some of the properties were previously set in the Options utility in version 3.02 of the Web Client
            'setup the mode and overall behavior of the opcdata.net component
            'From EasyDAClientModeClass
            ClientMode.AllowAsynchronousMethod = True 'When True, Async reads and write are allowed
            ClientMode.AllowSynchronousMethod = True 'When True, Sync reads and writes are allowed
            ClientMode.DesiredMethod = 1 'Determines if reads and writes are done async (1) or sync (2).

            '
            'From EasyDAClientHoldPeriods Class
            HoldPeriods.ItemDetach = TimeoutSeconds * 1000 'After an Item object is detached, connection will be maintained for this amount of time
            HoldPeriods.ServerDetach = TimeoutSeconds * 1000 'After an Item object is detached, connection will be maintained for the amount of time
            HoldPeriods.TopicRead = TimeoutSeconds * 1000 'After read, connection will be maintained at least for this amount of time
            HoldPeriods.TopicWrite = TimeoutSeconds * 1000 'After write, connection will be maintained at least for this amount of time

            '
            'From EasyDAClientTimeouts Class
            Timeouts.BrowseAccessPaths = 5000 'maximum time operation will wait for method to complete (success or failure)
            Timeouts.BrowseNodes = 5000 'maximum time operation will wait for BrowseBranches, BrowseLeaves and BrowseNodes methods to complete (success or failure)
            Timeouts.BrowseProperties = 5000 'maximum time operation will wait for method to complete (success or failure)
            Timeouts.BrowseServers = 5000 'maximum time operation will wait for any browse method to complete (success or failure)
            Timeouts.GetProperty = 5000 'maximum time operation will wait for any get property method to complete (success or failure)
            Timeouts.ReadItem = 5000 'maximum time operation will wait for any read method to complete (success or failure)
            Timeouts.WriteItem = 5000 'maximum time operation will wait for any write method to complete (success or failure)

            '
            'EasyDAClientUpdateRates Class
            UpdateRates.ReadAutomatic = 500 'After read, the initial update rate is set to this value
            UpdateRates.WriteAutomatic = 500 'After write, the initial update rate of the item is set to this value

            '
            'now to read the tag and to verify its success
            Dim theTag As DAVtq = EasyOPC.ReadItem(pc, opc, tag)

            MessageBox.Show("Channel1.Device1.Tag1 = " & theTag.Value.ToString & "(" & theTag.Quality.ToString & ") at " & theTag.Timestamp.ToString)

        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub
End Class
